#define vec2 float2
#define vec4 float4
#define rgb xyz
#define rgba xyzw

typedef struct
{
	int width[8];
	int height[8];
	float cur_time;
	float total_time;
	float origROI[4];
	float resultROI[4];
	float angle;
}FilterParam;

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;



vec4 INPUTSRC(image2d_t src_data, __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc);
}

vec4 INPUT(image2d_t ovelay1,  __global FilterParam* param, vec2 tc)
{
	return read_imagef(ovelay1, sampler, (vec2)(tc.x,tc.y) );
}

// Filter Blue skies
__kernel void filter_BlueSkies(__read_only image2d_t image,   		// image buffer 1
							   __write_only image2d_t retImage,   	// image result	
							   __global int* BlueTearB,   			// image buffer B
							   __global int* BlueTearG,   			// image buffer G
							   __global int* BlueTearR,   			// image buffer R
							   __private int alpha)	 				// blend factor, scrope[0-100]	
{
	int w = get_global_id(0);
	int h = get_global_id(1);
	int width = get_image_width(image);
	int height = get_image_height(image);

	if(w >= width || h >= height)
			return;
	const sampler_t sampler = CLK_NORMALIZED_COORDS_FALSE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;
	
	float4 color = read_imagef(image, sampler, (int2)(w, h));
    float4 orig =color;

	int r = color.x * 255;
	int g = color.y * 255;
	int b = color.z * 255;
	int a = color.w * 255;
		
	int tr =  BlueTearR[r];
	int tg =  BlueTearG[g];
	int tb =  BlueTearB[b];
		
	float factor = (float)(alpha)/100.0f;
    float4 texel =(float4)((float)(tr)/255.0f,(float)(tg)/255.0f,(float)(tb)/255.0f,orig.w);
	float4 outColor = mix(texel, orig, (float4)(1.0f - factor));
	write_imagef(retImage, (int2)(w, h), outColor);


}